<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ExamQuestion extends Model
{
    protected $table = 'exam_questions';
    protected $primaryKey = 'Question_id';
    public $timestamps = true;

    protected $fillable = [
        'Question_text',
        'Options',
        'Course_id',
        'Question_type',
        'Difficulty',
        'Metadata',
    ];

    protected $casts = [
        'Options' => 'array',
        'Metadata' => 'array',
        'Question_type' => 'string',
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
    ];

    public function course()
    {
        return $this->belongsTo(Course::class, 'Course_id', 'Course_id');
    }
}
